/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.beanvalidation.tck.tests.validation.OrderLine;
import org.hibernate.beanvalidation.tck.tests.validation.ProductCategory;

public class ContainerElementsOrder {
    @Size(min=6)
    private final @Size(min=6) String name;
    private Map<@NotNull ProductCategory, List<@Valid OrderLine>> lines = new HashMap<ProductCategory, List<OrderLine>>();

    public ContainerElementsOrder(String name) {
        this.name = name;
        this.lines = new HashMap<ProductCategory, List<OrderLine>>();
    }

    public ContainerElementsOrder(String name, Map<@NotNull ProductCategory, List<@Valid OrderLine>> lines) {
        this.name = name;
        this.lines = lines;
    }

    public String getName() {
        return this.name;
    }

    public void addOrderLine(ProductCategory category, OrderLine orderLine) {
        List lines = this.lines.computeIfAbsent(category, c -> new ArrayList());
        lines.add(orderLine);
    }

    public void replaceOrderLines(Map<@NotNull ProductCategory, List<@Valid OrderLine>> lines) {
        this.lines = lines;
    }

    @Valid
    public ContainerElementsOrder getOrder() {
        return this;
    }
}

