/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportFactory;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportPolicy;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.l10n.EMFClipboardCoreMessages;
import org.eclipse.osgi.util.NLS;

public class ClipboardSupportManager {
    public static final String EP_CLIPBOARD_SUPPORT = "org.eclipse.gmf.runtime.emf.clipboard.core.clipboardSupport";
    static final String E_NSURI = "nsURI";
    static final String E_CLASS = "class";
    static final String E_POLICY = "policy";
    static final String E_PRIORITY = "priority";
    private static final List PRIORITIES = Arrays.asList("lowest", "low", "medium", "high", "highest");
    private static ArrayList[] descriptors;

    private ClipboardSupportManager() {
    }

    public static void configureExtensions(IConfigurationElement[] configs) {
        descriptors = new ArrayList[PRIORITIES.size()];
        int i = 0;
        while (i < PRIORITIES.size()) {
            ClipboardSupportManager.descriptors[i] = new ArrayList(0);
            ++i;
        }
        i = 0;
        while (i < configs.length) {
            try {
                Descriptor desc = new Descriptor(configs[i]);
                descriptors[desc.getPriority()].add(desc);
            }
            catch (CoreException e) {
                ClipboardPlugin.getPlugin().log(e.getStatus());
            }
            ++i;
        }
    }

    public static IClipboardSupportFactory lookup(EPackage ePackage) {
        int i = PRIORITIES.size() - 1;
        while (i >= 0) {
            ArrayList descriptorsAtPriorityN = descriptors[i];
            int size = descriptorsAtPriorityN.size();
            int j = 0;
            while (j < size) {
                Descriptor descriptor = (Descriptor)descriptorsAtPriorityN.get(j);
                if (descriptor.provides(ePackage)) {
                    return descriptor.getFactory();
                }
                ++j;
            }
            --i;
        }
        return null;
    }

    public static IClipboardSupportFactory lookup(EClass eClass) {
        return ClipboardSupportManager.lookup(eClass.getEPackage());
    }

    public static IClipboardSupportFactory lookup(EObject eObject) {
        int i = PRIORITIES.size() - 1;
        while (i >= 0) {
            ArrayList descriptorsAtPriorityN = descriptors[i];
            int size = descriptorsAtPriorityN.size();
            int j = 0;
            while (j < size) {
                Descriptor descriptor = (Descriptor)descriptorsAtPriorityN.get(j);
                if (descriptor.provides(eObject)) {
                    return descriptor.getFactory();
                }
                ++j;
            }
            --i;
        }
        return null;
    }

    static IStatus createErrorStatus(int code, String message) {
        return ClipboardSupportManager.createErrorStatus(code, message, null);
    }

    static IStatus createErrorStatus(int code, String message, Throwable exception) {
        return new Status(4, ClipboardPlugin.getPlugin().getSymbolicName(), code, message, exception);
    }

    private static final class Descriptor {
        private EPackage ePackage = null;
        private IClipboardSupportFactory factory;
        private IClipboardSupportPolicy policy;
        private IConfigurationElement config;
        private int priority = 2;
        private boolean factoryClassInitialized = false;
        private boolean policyClassInitialized = false;

        Descriptor(IConfigurationElement config) throws CoreException {
            String className;
            this.config = config;
            String nsUri = config.getAttribute(ClipboardSupportManager.E_NSURI);
            if (nsUri != null && nsUri.length() > 0) {
                this.ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
                if (this.ePackage == null) {
                    throw new CoreException(ClipboardSupportManager.createErrorStatus(32, NLS.bind((String)EMFClipboardCoreMessages.unresolved_nsUri_ERROR_, (Object[])new Object[]{"clipboardSupport", nsUri, config.getDeclaringExtension().getNamespaceIdentifier()})));
                }
            } else {
                String policy = config.getAttribute(ClipboardSupportManager.E_POLICY);
                if (policy == null || policy.length() == 0) {
                    throw new CoreException(ClipboardSupportManager.createErrorStatus(31, NLS.bind((String)EMFClipboardCoreMessages.missing_nsUri_ERROR_, (Object[])new Object[]{"clipboardSupport", config.getDeclaringExtension().getNamespaceIdentifier()})));
                }
            }
            if ((className = config.getAttribute(ClipboardSupportManager.E_CLASS)) == null || className.length() == 0) {
                throw new CoreException(ClipboardSupportManager.createErrorStatus(31, NLS.bind((String)EMFClipboardCoreMessages.missing_class_ERROR_, (Object[])new Object[]{"clipboardSupport", config.getDeclaringExtension().getNamespaceIdentifier()})));
            }
            String priorityStr = config.getAttribute(ClipboardSupportManager.E_PRIORITY);
            if (priorityStr != null) {
                priorityStr = priorityStr.toLowerCase();
                if (PRIORITIES.contains(priorityStr)) {
                    this.priority = PRIORITIES.indexOf(priorityStr);
                }
            }
        }

        private boolean provides(EPackage ePackage) {
            return ePackage != null && ePackage.equals(this.getEPackage());
        }

        private boolean provides(EObject eObject) {
            this.policy = this.getPolicy();
            if (this.policy != null) {
                try {
                    return this.policy.provides(new EObjectAdapter(eObject));
                }
                catch (Throwable e) {
                    ClipboardPlugin.getPlugin().log(ClipboardSupportManager.createErrorStatus(31, NLS.bind((String)EMFClipboardCoreMessages.missing_class_ERROR_, (Object[])new Object[]{IClipboardSupportFactory.class.getName(), this.config.getAttribute(ClipboardSupportManager.E_POLICY)}), e));
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    if (e instanceof VirtualMachineError) {
                        throw (VirtualMachineError)e;
                    }
                    return false;
                }
            }
            return this.provides(eObject.eClass().getEPackage());
        }

        EPackage getEPackage() {
            return this.ePackage;
        }

        int getPriority() {
            return this.priority;
        }

        IClipboardSupportFactory getFactory() {
            if (this.factory == null && !this.factoryClassInitialized) {
                this.factoryClassInitialized = true;
                this.factory = this.createFactory();
            }
            return this.factory;
        }

        IClipboardSupportPolicy getPolicy() {
            if (this.policy == null && !this.policyClassInitialized) {
                this.policyClassInitialized = true;
                this.policy = this.createPolicy();
            }
            return this.policy;
        }

        private IClipboardSupportFactory createFactory() {
            IClipboardSupportFactory result = null;
            try {
                result = (IClipboardSupportFactory)this.config.createExecutableExtension(ClipboardSupportManager.E_CLASS);
            }
            catch (CoreException e) {
                ClipboardPlugin.getPlugin().log(e.getStatus());
            }
            catch (Exception e) {
                ClipboardPlugin.getPlugin().log(ClipboardSupportManager.createErrorStatus(33, NLS.bind((String)EMFClipboardCoreMessages.factory_failed_ERROR_, (Object[])new Object[]{IClipboardSupportFactory.class.getName(), this.config.getAttribute(ClipboardSupportManager.E_CLASS)}), e));
            }
            return result;
        }

        private IClipboardSupportPolicy createPolicy() {
            IClipboardSupportPolicy result = null;
            String policyClassName = this.config.getAttribute(ClipboardSupportManager.E_POLICY);
            if (policyClassName != null && policyClassName.length() > 0) {
                try {
                    result = (IClipboardSupportPolicy)this.config.createExecutableExtension(ClipboardSupportManager.E_POLICY);
                }
                catch (CoreException e) {
                    ClipboardPlugin.getPlugin().log(e.getStatus());
                }
                catch (Exception e) {
                    ClipboardPlugin.getPlugin().log(ClipboardSupportManager.createErrorStatus(31, NLS.bind((String)EMFClipboardCoreMessages.missing_class_ERROR_, (Object[])new Object[]{IClipboardSupportFactory.class.getName(), this.config.getAttribute(ClipboardSupportManager.E_POLICY)}), e));
                }
            }
            return result;
        }
    }

    private static class EObjectAdapter
    extends Proxy
    implements IAdaptable {
        public EObjectAdapter(EObject element) {
            super((Object)element);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isInstance(this.getRealObject())) {
                return this.getRealObject();
            }
            if (adapter.isInstance((Object)this)) {
                return this;
            }
            return null;
        }
    }
}

