/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.postgresql.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCDatabase;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.postgresql.catalog.loaders.PostgresAuthorizationIdentifierLoader;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.emf.common.util.EList;

public class PostgresCatalogDatabase
extends JDBCDatabase {
    private final Object AUTHORIZATION_IDS_LOCK = new Object();
    private Boolean authorizationIdsLoaded = Boolean.FALSE;
    private transient SoftReference authorizationIdLoaderRef;

    public PostgresCatalogDatabase(Connection connection) {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.AUTHORIZATION_IDS_LOCK;
        synchronized (object) {
            if (this.authorizationIdsLoaded.booleanValue()) {
                this.authorizationIdsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAuthorizationIds() {
        Object object = this.AUTHORIZATION_IDS_LOCK;
        synchronized (object) {
            if (!this.authorizationIdsLoaded.booleanValue()) {
                this.loadAuthorizationIdentifiers();
            }
        }
        return super.getAuthorizationIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuthorizationIdentifiers() {
        Object object = this.AUTHORIZATION_IDS_LOCK;
        synchronized (object) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getAuthorizationIds();
                        ArrayList existingAuthorizationIds = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getAuthorizationIdentifierLoader().loadAuthorizationIdentifiers((List)container, existingAuthorizationIds);
                        this.getAuthorizationIdentifierLoader().clearAuthorizationIdentifiers(existingAuthorizationIds);
                        this.authorizationIdsLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    protected final PostgresAuthorizationIdentifierLoader getAuthorizationIdentifierLoader() {
        if (this.authorizationIdLoaderRef == null || this.authorizationIdLoaderRef.get() == null) {
            this.authorizationIdLoaderRef = new SoftReference<PostgresAuthorizationIdentifierLoader>(this.createAuthorizationIdentifierLoader());
        }
        return (PostgresAuthorizationIdentifierLoader)((Object)this.authorizationIdLoaderRef.get());
    }

    private PostgresAuthorizationIdentifierLoader createAuthorizationIdentifierLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLAccessControlPackage.eINSTANCE.getAuthorizationIdentifier().getInstanceClassName());
        if (loader != null) {
            PostgresAuthorizationIdentifierLoader authorizationIdLoader = (PostgresAuthorizationIdentifierLoader)loader;
            authorizationIdLoader.setCatalogObject((ICatalogObject)this);
            return authorizationIdLoader;
        }
        return new PostgresAuthorizationIdentifierLoader((ICatalogObject)this);
    }
}

