/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class CaseControlledWordRule
extends WordRule {
    private boolean caseSensitive = false;
    private StringBuffer fBuffer = new StringBuffer();

    public CaseControlledWordRule(IWordDetector detector) {
        super(detector);
    }

    public CaseControlledWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public CaseControlledWordRule(IWordDetector detector, IToken defaultToken, boolean caseSensitive) {
        this(detector, defaultToken);
        this.setCaseSensitive(caseSensitive);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            IToken token;
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (this.fDetector.isWordPart((char)(c = scanner.read())));
            scanner.unread();
            if (this.isCaseSensitive()) {
                token = (IToken)this.fWords.get(this.fBuffer.toString());
            } else {
                String keyString = this.fBuffer.toString().toUpperCase();
                token = (IToken)this.fWords.get(keyString);
            }
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
    }
}

