/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.nls;

import java.lang.reflect.Method;
import org.eclipse.osgi.util.TextProcessor;

public class TextProcessorWrapper {
    private static final String DEPROCESS_METHOD_NAME = "deprocess";
    private static Method sm_deprocessMethod = null;
    private static boolean sm_hasDeprocessMethod = true;
    private static final char LRM = '\u200e';
    private static final char LRE = '\u202a';
    private static final char PDF = '\u202c';
    private static boolean isBidi = false;
    private static boolean isSupportedPlatform = false;

    public static String deprocess(String str) {
        return TextProcessor.deprocess((String)str);
    }

    protected static String invokeDeprocess(String str) throws Exception {
        Method deprocessMethod = TextProcessorWrapper.getDeprocessMethod();
        Object returnValue = deprocessMethod.invoke(null, str);
        if (returnValue instanceof String) {
            return (String)returnValue;
        }
        sm_hasDeprocessMethod = false;
        throw new NoSuchMethodException(DEPROCESS_METHOD_NAME);
    }

    private static Method getDeprocessMethod() throws Exception {
        if (!sm_hasDeprocessMethod) {
            throw new NoSuchMethodException(DEPROCESS_METHOD_NAME);
        }
        if (sm_deprocessMethod == null) {
            Class<TextProcessor> processorClass = TextProcessor.class;
            try {
                sm_deprocessMethod = processorClass.getMethod(DEPROCESS_METHOD_NAME, String.class);
            }
            catch (Exception e) {
                sm_hasDeprocessMethod = false;
                throw e;
            }
        }
        return sm_deprocessMethod;
    }

    protected static String deprocessImpl(String str) {
        if (str == null || str.length() <= 1 || !isSupportedPlatform || !isBidi) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\u202a': {
                    break;
                }
                case '\u202c': {
                    break;
                }
                case '\u200e': {
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String process(String text) {
        return TextProcessor.process((String)text);
    }

    public static String process(String str, String delimiter) {
        return TextProcessor.process((String)str, (String)delimiter);
    }

    public static String getDefaultDelimiters() {
        return TextProcessor.getDefaultDelimiters();
    }
}

