/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.ddl;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.GenericCatalogMessages;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;

public class SqlServer2000DdlBuilder
extends GenericDdlBuilder {
    protected static final String ACTION = "ACTION";
    protected static final String ANSI_NULLS = "ANSI_NULLS";
    protected static final String ANSI_PADDING = "ANSI_PADDING";
    protected static final String OFF = "OFF";
    protected static final String OUT = "OUT";
    protected static final String QUOTED_IDENTIFIER = "QUOTED_IDENTIFIER";
    private Set elements;

    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer statement = new StringBuffer();
        boolean isTemp = table instanceof TemporaryTable;
        statement.append("CREATE").append(" ");
        if (isTemp) {
            if (((TemporaryTable)table).isLocal()) {
                statement.append("LOCAL").append(" ");
            } else {
                statement.append("GLOBAL").append(" ");
            }
            statement.append("TEMPORARY").append(" ");
        }
        statement.append("TABLE").append(" ").append(this.getName((Table)table, quoteIdentifiers, qualifyNames)).append(" ");
        statement.append("(").append(NEWLINE);
        ArrayList items = new ArrayList();
        items.addAll(table.getColumns());
        items.addAll(this.getTableConstraints((Table)table));
        Iterator it = items.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String clause;
            Object item = it.next();
            if (item instanceof Column) {
                clause = this.getColumnString((Column)item, quoteIdentifiers);
            } else if (item instanceof CheckConstraint) {
                clause = this.getCheckConstraintClause((CheckConstraint)item, quoteIdentifiers);
            } else {
                if (!(item instanceof UniqueConstraint)) continue;
                clause = this.getUniqueConstraintClause((UniqueConstraint)item, quoteIdentifiers);
            }
            if (!first) {
                statement.append(",");
                statement.append(NEWLINE);
            } else {
                first = false;
            }
            statement.append("\t").append(clause);
        }
        statement.append(NEWLINE).append(")");
        if (isTemp) {
            statement.append(NEWLINE).append("\t").append("ON COMMIT").append(" ");
            if (((TemporaryTable)table).isDeleteOnCommit()) {
                statement.append("DELETE").append(" ");
            } else {
                statement.append("PRESERVE").append(" ");
            }
            statement.append("ROWS");
        }
        return statement.append(NEWLINE).toString();
    }

    private Set getTableConstraints(Table table) {
        HashSet constraints = new HashSet(this.elements.size());
        for (Object elem : this.elements) {
            if (!(elem instanceof TableConstraint) || ((TableConstraint)elem).getBaseTable() != table) continue;
            constraints.add(elem);
        }
        return constraints;
    }

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String body;
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE").append(" ").append("PROCEDURE").append(" ").append(this.getName((Routine)procedure, quoteIdentifiers, qualifyNames)).append(" ");
        statement.append(this.getParameterListClause((Routine)procedure, false));
        if (procedure.getLanguage() != null && procedure.getLanguage().length() > 0) {
            statement.append("\t").append("LANGUAGE").append(" ").append(procedure.getLanguage()).append(NEWLINE);
        }
        if (procedure.getParameterStyle() != null && procedure.getParameterStyle().length() > 0) {
            statement.append("\t").append("PARAMETER STYLE").append(" ").append(procedure.getParameterStyle()).append(NEWLINE);
        }
        if (procedure.getMaxResultSets() > 0) {
            statement.append("\t").append("DYNAMIC RESULT SETS").append(" ").append(procedure.getMaxResultSets()).append(NEWLINE);
        }
        if (procedure.getSource() != null && (body = procedure.getSource().getBody()) != null && body.length() > 0) {
            statement.append("AS").append(NEWLINE).append(body).append(NEWLINE);
        }
        return statement.append(NEWLINE).toString();
    }

    protected String getParameterListClause(Routine routine, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer();
        statement.append(NEWLINE);
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            String name = param.getName();
            if (name.equals("@RETURN_VALUE")) continue;
            ParameterMode mode = param.getMode();
            statement.append("\t").append("\t");
            if (name != null && name.length() > 0) {
                statement.append(quoteIdentifiers ? this.getQuotedIdentifierString((SQLObject)param) : name).append(" ");
            }
            statement.append(this.getDataTypeString((TypedElement)param, routine.getSchema()));
            if (mode.getName().toLowerCase().equals("inout") || mode.getName().toLowerCase().equals("out")) {
                statement.append(" ").append(OUT).append(" ");
            }
            if (!it.hasNext()) continue;
            statement.append(",");
            statement.append(NEWLINE);
        }
        statement.append(NEWLINE);
        return statement.toString();
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP INDEX " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + "." + this.getName(index, quoteIdentifiers, false) + NEWLINE;
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        if (index.isUnique()) {
            statement = String.valueOf(statement) + "UNIQUE ";
        }
        statement = String.valueOf(statement) + "INDEX " + this.getName(index, quoteIdentifiers, false) + " " + "ON" + " " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + " " + "(" + this.getIndexKeyColumns(index, quoteIdentifiers) + ")";
        return String.valueOf(statement) + NEWLINE;
    }

    public final String asOnOff(boolean flag) {
        return flag ? "ON" : OFF;
    }

    public void setElements(Set elements) {
        this.elements = elements;
    }

    public final void clear() {
        this.elements = null;
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        return "ADD " + this.getUniqueConstraintClause(constraint, quoteIdentifiers) + NEWLINE;
    }

    protected String getUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        String text = "CONSTRAINT " + this.getName((TableConstraint)constraint, quoteIdentifiers) + " " + this.getUniqueConstraintType(constraint) + " " + "(" + this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers) + ")";
        this.findIndexByConstraint((ReferenceConstraint)constraint);
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + " " + this.getDeferrableClause((Constraint)constraint);
        }
        return String.valueOf(text) + NEWLINE;
    }

    public ReferenceConstraint findConstraintByIndex(Index index) {
        for (Object elem : this.elements) {
            if (!(elem instanceof ReferenceConstraint) || !((ReferenceConstraint)elem).getName().equals(index.getName())) continue;
            return (ReferenceConstraint)elem;
        }
        return null;
    }

    public Index findIndexByConstraint(ReferenceConstraint constraint) {
        for (Object elem : this.elements) {
            if (!(elem instanceof Index) || !((Index)elem).getName().equals(constraint.getName())) continue;
            return (Index)elem;
        }
        return null;
    }

    public String createUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return super.createUserDefinedType(type, quoteIdentifiers, qualifyNames);
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format((String)GenericCatalogMessages.FE_PARENT_TABLLE_OR_KEY_DO_NOT_EXIST, (Object[])new Object[]{foreignKey.getName()}));
            return null;
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + " " + "ADD" + " " + "CONSTRAINT" + " " + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + " " + "FOREIGN KEY" + " " + "(" + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers) + ")" + NEWLINE;
        statement = String.valueOf(statement) + "\tREFERENCES " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + " " + "(" + parentKey + ")";
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.RESTRICT_LITERAL && action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "DELETE" + " ";
            statement = String.valueOf(statement) + this.getReferentialAction(action);
        }
        if ((action = foreignKey.getOnUpdate()) != ReferentialActionType.RESTRICT_LITERAL && action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "UPDATE" + " ";
            statement = String.valueOf(statement) + this.getReferentialAction(action);
        }
        if (foreignKey.isDeferrable()) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + this.getDeferrableClause((Constraint)foreignKey);
        }
        return String.valueOf(statement) + NEWLINE;
    }

    public String addUniqueConstraint(Index constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName(constraint.getTable(), quoteIdentifiers, qualifyNames) + " ";
        statement = String.valueOf(statement) + this.getAddUniqueConstraintClause(constraint, quoteIdentifiers);
        return String.valueOf(statement) + NEWLINE;
    }

    protected String getAddUniqueConstraintClause(Index constraint, boolean quoteIdentifiers) {
        return "ADD " + this.getUniqueConstraintClause(constraint, quoteIdentifiers) + NEWLINE;
    }

    protected String getUniqueConstraintClause(Index constraint, boolean quoteIdentifiers) {
        String text = "CONSTRAINT " + this.getName(constraint, quoteIdentifiers, false) + " " + "UNIQUE" + " " + "(" + this.getIndexKeyColumns(constraint, quoteIdentifiers) + ")";
        return String.valueOf(text) + NEWLINE;
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames) + NEWLINE;
    }

    public String dropTableConstraint(Index uniqueIndex, boolean quoteIdentifiers, boolean qualifyNames) {
        return "ALTER TABLE " + this.getName(uniqueIndex.getTable(), quoteIdentifiers, qualifyNames) + " DROP CONSTRAINT " + this.getName(uniqueIndex, quoteIdentifiers, false) + NEWLINE;
    }

    public String dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return String.valueOf(super.dropTableConstraint(constraint, quoteIdentifiers, qualifyNames)) + NEWLINE;
    }

    public String[] createSetOptions(SQLObject[] elements) {
        String[] setOptions = new String[]{"SET ANSI_NULLS ON" + NEWLINE, "SET QUOTED_IDENTIFIER ON" + NEWLINE, "SET ANSI_PADDING ON" + NEWLINE};
        return setOptions;
    }

    public String[] createUnsetOptions(SQLObject[] elements) {
        String[] unsetOptions = new String[]{"SET ANSI_PADDING OFF" + NEWLINE};
        return unsetOptions;
    }
}

