/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.osgi.framework.BundleContext;

public class SQLQueryParserPlugin
extends Plugin
implements IRegistryChangeListener {
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.parsers.sql.query";
    public static final String EXTENSION_POINT_ID = "vendorExtension";
    public static final String EXTENSION_CONFIGURATION_TAG = "parserExtension";
    public static final String EXTENSION_ATTRIBUTE_PRODUCT = "product";
    public static final String EXTENSION_ATTRIBUTE_TOVERSION = "toVersion";
    public static final String EXTENSION_ATTRIBUTE_FROMVERSION = "fromVersion";
    public static final String EXTENSION_ATTRIBUTE_PARSERMANAGER = "parserManager";
    private static SQLQueryParserPlugin plugin;
    private ResourceBundle resourceBundle;
    private static Map parserManagerConfigElementMap;

    static {
        parserManagerConfigElementMap = new HashMap();
    }

    public SQLQueryParserPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.parsers.sql.query.sqlqueryparsermessages");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerPluginExtensions();
    }

    protected void registerPluginExtensions() {
        SQLQueryParserManagerProvider parserManagerProvider = SQLQueryParserManagerProvider.getInstance();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals(EXTENSION_CONFIGURATION_TAG)) {
                        IConfigurationElement configElement = configElements[j];
                        String parserManagerClassName = configElements[j].getAttribute(EXTENSION_ATTRIBUTE_PARSERMANAGER);
                        String dbProductName = configElements[j].getAttribute(EXTENSION_ATTRIBUTE_PRODUCT);
                        String latestDbVersion = configElements[j].getAttribute(EXTENSION_ATTRIBUTE_TOVERSION);
                        String earliestDbVersion = configElements[j].getAttribute(EXTENSION_ATTRIBUTE_FROMVERSION);
                        if (dbProductName != null && parserManagerClassName != null) {
                            parserManagerProvider.registerParserManager(parserManagerClassName, dbProductName, earliestDbVersion, latestDbVersion);
                            parserManagerConfigElementMap.put(parserManagerClassName, configElement);
                        } else {
                            String msg = "unable to register parserManager " + parserManagerClassName + " for " + EXTENSION_ATTRIBUTE_PRODUCT + " " + dbProductName + " in extension-point: " + PLUGIN_ID + "." + EXTENSION_POINT_ID + " configuration: " + EXTENSION_CONFIGURATION_TAG + "[" + i + "]";
                            this.getLog().log((IStatus)new Status(4, SQLQueryParserPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, null));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.getLog().log((IStatus)new Status(4, SQLQueryParserPlugin.getDefault().getBundle().getSymbolicName(), 0, "extension-point could not be found for org.eclipse.datatools.sqltools.parsers.sql.query.vendorExtension", null));
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static SQLQueryParserPlugin getDefault() {
        return plugin;
    }

    protected SQLQueryParserManager instanciateParserManager(String parserManagerClassName) {
        SQLQueryParserManager parserManager = null;
        IConfigurationElement configElement = (IConfigurationElement)parserManagerConfigElementMap.get(parserManagerClassName);
        try {
            parserManager = (SQLQueryParserManager)((Object)configElement.createExecutableExtension(EXTENSION_ATTRIBUTE_PARSERMANAGER));
        }
        catch (CoreException e) {
            this.getLog().log((IStatus)new Status(4, SQLQueryParserPlugin.getDefault().getBundle().getSymbolicName(), 0, String.valueOf(parserManagerClassName) + " could not be initialized" + e.getMessage(), (Throwable)e));
        }
        return parserManager;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SQLQueryParserPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        SQLQueryParserManagerProvider.getInstance().clearParserManagerRegistry();
        this.registerPluginExtensions();
    }
}

