/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCCatalog;
import org.eclipse.datatools.connectivity.sqm.loader.CatalogFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class JDBCCatalogLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_CAT = "TABLE_CAT";

    public JDBCCatalogLoader(ICatalogObject catalogObject) {
        this(catalogObject, new CatalogFilterProvider());
    }

    public JDBCCatalogLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof Database);
    }

    public Collection loadCatalogs() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadCatalogs(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadCatalogs(List containmentList, Collection existingCatalogs) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            boolean catalogsFiltered = false;
            rs = this.createResultSet();
            while (rs.next()) {
                String catalogName = rs.getString(COLUMN_TABLE_CAT);
                if (catalogName == null || this.isFiltered(catalogName)) {
                    catalogsFiltered = true;
                    continue;
                }
                Catalog catalog = (Catalog)this.getAndRemoveSQLObject(existingCatalogs, catalogName);
                if (catalog == null) {
                    catalog = this.processRow(rs);
                    if (catalog == null) continue;
                    containmentList.add(catalog);
                    continue;
                }
                containmentList.add(catalog);
                if (!(catalog instanceof ICatalogObject)) continue;
                ((ICatalogObject)catalog).refresh();
            }
            if (containmentList.size() == 0 && !catalogsFiltered) {
                Catalog catalog = (Catalog)this.getAndRemoveSQLObject(existingCatalogs, new String());
                if (catalog == null) {
                    catalog = this.createCatalog();
                    catalog.setName(new String());
                } else if (catalog instanceof ICatalogObject) {
                    ((ICatalogObject)catalog).refresh();
                }
                containmentList.add(catalog);
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearCatalogs(Collection catalogs) {
        catalogs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            return this.getCatalogObject().getConnection().getMetaData().getCatalogs();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getCatalog()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Catalog processRow(ResultSet rs) throws SQLException {
        Catalog catalog = this.createCatalog();
        this.initialize(catalog, rs);
        return catalog;
    }

    protected Catalog createCatalog() {
        return new JDBCCatalog();
    }

    protected void initialize(Catalog catalog, ResultSet rs) throws SQLException {
        catalog.setName(rs.getString(COLUMN_TABLE_CAT));
    }

    protected Database getDatabase() {
        return (Database)this.getCatalogObject();
    }
}

