/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.common.ui.dialog.SaveAsDialog;
import org.eclipse.datatools.sqltools.common.ui.sqlstatementarea.ISQLSourceViewerService;
import org.eclipse.datatools.sqltools.common.ui.sqlstatementarea.SQLStatementArea;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SQLExecutionJobListener;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core.ScriptsExecutionRunnable;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.CommonAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.SQLSourceViewerConfiguration;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.SQLSourceViewerService;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class SavePreviewDialog
extends Dialog {
    private Button _notShowAgain;
    private Button _execute;
    private Button _saveAs;
    private Button _cancel;
    private String _scripts;
    private DatabaseIdentifier _databaseIdentifier;
    private ISchemaObjectEditor _editor;
    private SQLStatementArea _sta;
    private Map _actions = new HashMap();
    IPreferenceStore _store = SOEUIPlugin.getDefault().getPreferenceStore();
    private boolean _syncSave;
    private IProgressMonitor _monitor;
    private boolean _executing = false;
    private String _groupExecutionDspString;
    private String _consumerName;

    public SavePreviewDialog(Shell parentShell, String scripts, DatabaseIdentifier databaseIdentifier, ISchemaObjectEditor editor, boolean syncSave, IProgressMonitor monitor, String groupExecutionDspString, String consumerName) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._scripts = scripts;
        this._databaseIdentifier = databaseIdentifier;
        this._editor = editor;
        this._syncSave = syncSave;
        this._monitor = monitor;
        this._groupExecutionDspString = groupExecutionDspString;
        this._consumerName = consumerName;
    }

    private void initializeActions() {
        CommonAction action = new CommonAction(this._sta.getViewer().getTextOperationTarget(), 4, Messages.SavePreviewDialog_copy);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this._actions.put(ITextEditorActionConstants.COPY, action);
        action = new CommonAction(this._sta.getViewer().getTextOperationTarget(), 7, Messages.SavePreviewDialog_select_all);
        this._actions.put(ITextEditorActionConstants.SELECT_ALL, action);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SavePreviewDialog_preview);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite outter = new Composite(parent, 0);
        outter.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        outter.setLayout((Layout)layout);
        Composite top = new Composite(outter, 0);
        top.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        top.setLayoutData((Object)gd);
        this.createSQLArea(top);
        Composite bottom = new Composite(outter, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(768));
        this._notShowAgain = new Button(bottom, 32);
        this._notShowAgain.setText(Messages.SavePreviewDialog_not_show_again);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this._notShowAgain.setLayoutData((Object)gd);
        this._notShowAgain.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SavePreviewDialog.this._store.setValue("SchemaObjectEditorPreferencePage.show.preview.dialog", !SavePreviewDialog.this._notShowAgain.getSelection());
            }
        });
        this._execute = new Button(bottom, 0);
        this._execute.setText(Messages.SavePreviewDialog_execute);
        this._execute.setLayoutData((Object)new GridData());
        this._execute.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ScriptsExecutionRunnable scriptsRunnable = new ScriptsExecutionRunnable(SavePreviewDialog.this._scripts, SavePreviewDialog.this._databaseIdentifier, new SQLExecutionJobListener(SavePreviewDialog.this._editor, SavePreviewDialog.this._monitor), SavePreviewDialog.this._syncSave, SavePreviewDialog.this._monitor, SavePreviewDialog.this._groupExecutionDspString, SavePreviewDialog.this._consumerName);
                scriptsRunnable.run();
                SavePreviewDialog.this._executing = true;
                SavePreviewDialog.this.close();
            }
        });
        this._saveAs = new Button(bottom, 0);
        this._saveAs.setText(Messages.SavePreviewDialog_save_as);
        this._saveAs.setLayoutData((Object)new GridData());
        this._saveAs.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SaveAsDialog dlg = new SaveAsDialog(SOEUIPlugin.getActiveWorkbenchShell(), SavePreviewDialog.this._scripts);
                IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
                boolean isOpen = store.getBoolean("SchemaObjectEditorPreferencePage.open.file.after.saveas");
                dlg.setOriginalName(String.valueOf(SavePreviewDialog.this._editor.getDisplayName()) + "_edit.sql");
                dlg.setOpenMode(isOpen);
                dlg.open();
                IEditorPart editor = dlg.getEditor();
                if (editor != null && editor instanceof SQLEditor) {
                    SQLEditorConnectionInfo connInfo = new SQLEditorConnectionInfo(SQLToolsFacade.getConfigurationByProfileName((String)SavePreviewDialog.this._databaseIdentifier.getProfileName()).getDatabaseVendorDefinitionId(), SavePreviewDialog.this._databaseIdentifier.getProfileName(), SavePreviewDialog.this._databaseIdentifier.getDBname(), SavePreviewDialog.this._databaseIdentifier.getDBname());
                    ((SQLEditor)editor).setConnectionInfo((ISQLEditorConnectionInfo)connInfo);
                }
                SavePreviewDialog.this.close();
            }
        });
        this._cancel = new Button(bottom, 0);
        this._cancel.setText(Messages.SavePreviewDialog_cancel);
        this._cancel.setLayoutData((Object)new GridData());
        this._cancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SavePreviewDialog.this.close();
            }
        });
        boolean dontShowPreview = !this._store.getBoolean("SchemaObjectEditorPreferencePage.show.preview.dialog");
        this._notShowAgain.setSelection(dontShowPreview);
        return outter;
    }

    private void createSQLArea(Composite comp) {
        String dbType = String.valueOf(this._editor.getEditorDescriptor().getVendorName()) + "_" + this._editor.getEditorDescriptor().getVersion();
        this._sta = new SQLStatementArea(comp, 2048, (ISQLSourceViewerService)new SQLSourceViewerService(), true);
        this._sta.setInput(this._scripts, dbType);
        this._sta.setEditable(false);
        this._sta.setEnabled(true);
        this._sta.configureViewer((SourceViewerConfiguration)new SQLSourceViewerConfiguration(dbType));
        this._sta.setLayoutData((Object)new GridData(1808));
        this.initializeActions();
        this.createContextMenu();
    }

    private void createContextMenu() {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object obj : SavePreviewDialog.this._actions.values()) {
                    if (!(obj instanceof IUpdate)) continue;
                    IUpdate action = (IUpdate)obj;
                    action.update();
                }
                menuMgr.add((IAction)SavePreviewDialog.this._actions.get(ITextEditorActionConstants.COPY));
                menuMgr.add((IAction)SavePreviewDialog.this._actions.get(ITextEditorActionConstants.SELECT_ALL));
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this._sta.getViewer().getTextWidget());
        this._sta.getViewer().getTextWidget().setMenu(menu);
    }

    public boolean close() {
        if (!this._executing && this._monitor != null) {
            this._monitor.setCanceled(true);
        }
        return super.close();
    }
}

