/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal;

import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SchemaEditorsHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ColorProvider;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.StatusLogger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SOEUIPlugin
extends AbstractUIPlugin {
    private ResourceBundle _bundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.LogMessages");
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.schemaobjecteditor.ui";
    private static SOEUIPlugin plugin;
    private ColorProvider _colorProvider;

    public SOEUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SchemaEditorsHandler handler = new SchemaEditorsHandler();
        SQLToolsConnectListenersManager.getInstance().addConnectListener((ISQLToolsConnectListener)handler);
        SQLToolsProfileListenersManager.getInstance().addProfileListener((ISQLToolsProfileListener)handler);
    }

    public void stop(BundleContext context) throws Exception {
        if (this._colorProvider != null) {
            this._colorProvider.dispose();
            this._colorProvider = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static SOEUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage workbenchPage = SOEUIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage != null) {
            return workbenchPage;
        }
        IWorkbenchPage[] workbenchPages = SOEUIPlugin.getActiveWorkbenchWindow().getPages();
        if (workbenchPages.length > 0) {
            return workbenchPages[0];
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = SOEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = SOEUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SOEUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = SOEUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public static ILogger getLogger(ResourceBundle bundle) {
        return new StatusLogger(SOEUIPlugin.getDefault().getLog(), PLUGIN_ID, bundle == null ? SOEUIPlugin.getDefault()._bundle : bundle);
    }

    public ColorProvider getColorProvider() {
        if (this._colorProvider == null) {
            this._colorProvider = new ColorProvider();
        }
        return this._colorProvider;
    }
}

