/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.ui.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class RefreshFromDatabaseAction
extends TextEditorAction
implements IPageUpdate {
    SQLEditor _sqlEditor;
    private boolean _isSourcePage = true;

    public RefreshFromDatabaseAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this._sqlEditor = (SQLEditor)editor;
        this.setImageDescriptor(RoutineEditorImages.getImageDescriptor("refresh_from_database"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.refreshFromDatabaseAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"refresh_from_database_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void run() {
        try {
            IRoutineEditorDocumentProvider sqlEditorDocumentProvider = null;
            if (this._sqlEditor.getParentEditor() != null) {
                sqlEditorDocumentProvider = (IRoutineEditorDocumentProvider)this._sqlEditor.getParentEditor().getAdapter(IRoutineEditorDocumentProvider.class);
            }
            if (sqlEditorDocumentProvider == null) {
                sqlEditorDocumentProvider = (IRoutineEditorDocumentProvider)this._sqlEditor.getDocumentProvider();
            }
            ProcIdentifier procIdentifier = ((ProcEditorInput)this._sqlEditor.getEditorInput()).getProcIdentifier();
            IControlConnection controlConnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(procIdentifier.getDatabaseIdentifier());
            sqlEditorDocumentProvider.refreshFromDatabase(this._sqlEditor.getEditorInput(), controlConnection, procIdentifier);
            SQLEditorPlugin.getActiveEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(Messages.RefreshFromDatabase_success);
        }
        catch (Exception e) {
            try {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.sqltools.routineeditor.ui", 0, NLS.bind((String)Messages.RefreshFromDatabase_fail, (Object[])new Object[]{e.toString()}), (Throwable)e));
            }
            catch (CoreException e1) {
                RoutineEditorUIActivator.getDefault().log(e1);
            }
        }
    }

    public void update() {
        this._sqlEditor = (SQLEditor)this.getTextEditor();
        if (this._sqlEditor.getEditorInput() instanceof ProcEditorInput) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

