/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Messages;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.ObjectTransfer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataTableCursor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class CutRowAction
extends Action {
    protected Clipboard _clipboard;
    protected IRowData _removedRow;
    private AccessibleTableViewer _accessibleTableViewer;

    public CutRowAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard) {
        this.setText(Messages.CutRowAction_text);
        this._accessibleTableViewer = accessibleTableViewer;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this._clipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"cut_row_action", (String)Activator.getDefault().getBundle().getSymbolicName()));
    }

    public void setViewer(AccessibleTableViewer accessibleTableViewer) {
        this._accessibleTableViewer = accessibleTableViewer;
    }

    public void run() {
        if (this._clipboard == null) {
            return;
        }
        TableDataTableCursor cursor = this._accessibleTableViewer.getCursor();
        if (!cursor.getVisible() || cursor.getRow() == null || !(cursor.getRow().getData() instanceof IRowData)) {
            return;
        }
        if (this._accessibleTableViewer.getInput() instanceof ITableData) {
            ITableData tableData = (ITableData)this._accessibleTableViewer.getInput();
            this._removedRow = (IRowData)cursor.getRow().getData();
            this._accessibleTableViewer.remove(this._removedRow);
            tableData.deleteRow(this._removedRow);
            Object[] data = new Object[]{this._removedRow};
            Transfer[] transfers = new Transfer[]{ObjectTransfer.getInstance()};
            this._clipboard.setContents(data, transfers);
            this._accessibleTableViewer.refresh();
        }
    }

    public void updateEnablement() {
        this.setEnabled(false);
        if (this._clipboard == null) {
            return;
        }
        if (this._accessibleTableViewer == null || this._accessibleTableViewer.getCursor().isDisposed() || this._accessibleTableViewer.getCursor().getRow() == null || !(this._accessibleTableViewer.getCursor().getRow().getData() instanceof IRowData)) {
            return;
        }
        this.setEnabled(true);
    }
}

