/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui.INameCompositeProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.general.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.modelvalidity.DiagnosticUtil;
import org.eclipse.datatools.sqltools.core.modelvalidity.SQLModelValidationDelegate;
import org.eclipse.datatools.sqltools.core.modelvalidity.ValidationItem;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.sql.updater.ProceduralObjectSourceUpdater;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class ProceduralObjectGeneralPage
extends SchemaObjectEditorPage
implements ISchemaObjectEditorPage {
    protected INameCompositeProvider _nameProvider;
    protected SQLObject _mainObject;
    protected ISchemaObjectEditModel _editModelObject;
    protected DatabaseDefinition _databaseDefinition;
    protected DatabaseIdentifier _databaseIdentifier;
    protected Boolean _inInit = Boolean.TRUE;
    protected ProceduralObjectSourceUpdater _updater = null;
    protected boolean _enabled = true;
    protected Composite _comp;
    protected Boolean _nameChanged = Boolean.FALSE;
    protected NameValidator _nameValidator = new NameValidator();

    protected void createFormContent(IManagedForm managedForm) {
        Composite comp;
        super.createFormContent(managedForm);
        this._comp = comp = managedForm.getForm().getBody();
        managedForm.getForm().setText(Messages.ProceduralObjectGeneralPage_page_name);
        TableWrapLayout layout = new TableWrapLayout();
        comp.setLayout((Layout)layout);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite(comp);
        layout = new TableWrapLayout();
        container.setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(256, 256);
        container.setLayoutData((Object)td);
        this.composeSections(toolkit, container);
        this._comp.setEnabled(this._enabled);
        ProcIdentifier proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)this._databaseIdentifier, (SQLObject)this._mainObject);
        if (proc != null && SPDebugModelUtil.isProcInDebugging((ProcIdentifier)proc)) {
            this._comp.setEnabled(false);
        }
    }

    protected void composeSections(FormToolkit toolkit, Composite container) {
        this.createTitleSection(toolkit, container);
    }

    protected void createTitleSection(FormToolkit toolkit, Composite container) {
        Section title = toolkit.createSection(container, 0);
        TableWrapData td1 = new TableWrapData(256, 256);
        title.setLayoutData((Object)td1);
        this._nameProvider = this.createNameComposite();
        Composite nameComp = this._nameProvider.getComposite((Composite)title, toolkit, 0);
        title.setClient((Control)nameComp);
        this._nameProvider.getNameControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ProceduralObjectGeneralPage.this._inInit.booleanValue()) {
                    ProceduralObjectGeneralPage.this._nameChanged = Boolean.TRUE;
                    ProceduralObjectGeneralPage.this.markDirty();
                    ProceduralObjectGeneralPage.this.getSite().getShell().getDisplay().timerExec(1000, (Runnable)ProceduralObjectGeneralPage.this._nameValidator);
                }
            }
        });
        this._nameProvider.getNameControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                ProceduralObjectGeneralPage.this.validateName((TypedEvent)e);
            }
        });
    }

    protected abstract INameCompositeProvider createNameComposite();

    protected SQLObject[] getSQLObjects() {
        if (this._mainObject != null) {
            return new SQLObject[]{this._mainObject};
        }
        return super.getSQLObjects();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPageInput(input);
    }

    protected void setPageInput(IEditorInput input) {
        if (input instanceof SchemaObjectEditorInput) {
            this._editModelObject = ((SchemaObjectEditorInput)input).getEditModelObject();
            this._mainObject = this._editModelObject.getMainSQLObject();
            SQLObject oldMainObject = this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject();
            this._databaseDefinition = ModelUtil.getDatabaseDefinition((SQLObject)oldMainObject);
            this._databaseIdentifier = SQLDevToolsUtil.getDatabaseIdentifier((SQLObject)oldMainObject);
            this._updater = this.createSourceUpdater();
        }
    }

    protected abstract ProceduralObjectSourceUpdater createSourceUpdater();

    public void refresh() {
        super.refresh();
        this._mainObject = null;
        this._editModelObject = null;
        this.setPageInput(this.getEditorInput());
        if (!this.isPageOpened()) {
            return;
        }
        this._inInit = Boolean.TRUE;
        this.initControls();
        this._inInit = Boolean.FALSE;
    }

    protected void initControls() {
        this._nameProvider.getNameControl().setText(this._mainObject.getName());
        this._nameChanged = Boolean.FALSE;
        this.validateAndShowErrors(null);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this._inInit = Boolean.TRUE;
            this.initControls();
            this._inInit = Boolean.FALSE;
        }
    }

    public boolean canLeaveThePage() {
        Diagnostic d;
        Iterator iter;
        this._errorMsg = null;
        if (this._nameChanged.booleanValue()) {
            this._nameValidator.run();
        }
        if (this._diagnostics != null && ((Diagnostic)this._diagnostics).getChildren().size() > 0 && (iter = ((Diagnostic)this._diagnostics).getChildren().iterator()).hasNext() && (d = (Diagnostic)iter.next()).getSeverity() == 4) {
            this._errorMsg = d.getMessage();
        }
        if (this._errorMsg != null) {
            boolean goon = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.GeneralPage_warning, (String)NLS.bind((String)Messages.GeneralPage_warning_msg, (Object)this._errorMsg));
            if (goon) {
                this._errorMsg = null;
                this._diagnostics = new BasicDiagnostic();
            }
            return goon;
        }
        return true;
    }

    protected Map buildValidationContext(TypedEvent e) {
        Map context = null;
        context = e == null ? SQLModelValidationDelegate.getCompleteValidationContext((int)1) : SQLModelValidationDelegate.getBasicValidationContext();
        ArrayList<ValidationItem> items = new ArrayList<ValidationItem>();
        context.put("vitems", items);
        if (e == null || e.widget == this._nameProvider.getNameControl()) {
            ValidationItem item = new ValidationItem(1);
            if (e == null && this.renamed()) {
                item.getContext().put("validate_duplicate_name_via_db", true);
            }
            items.add(item);
        }
        return context;
    }

    protected boolean renamed() {
        SQLObject oldMainObject = this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject();
        return !oldMainObject.getName().equalsIgnoreCase(this._mainObject.getName());
    }

    protected Map buildSharedParams(TypedEvent e) {
        HashMap<String, DatabaseIdentifier> sharedParams = new HashMap<String, DatabaseIdentifier>();
        sharedParams.put("didentifier", this.getDatabaseIdentifier());
        return sharedParams;
    }

    protected DiagnosticChain getDiagnosticChain(TypedEvent event) {
        DiagnosticChain diagnosticChain = super.getDiagnosticChain(event);
        if (event == null || this._diagnostics == null) {
            return diagnosticChain;
        }
        Collection filtered = this.getFilteredDiagnostics((BasicDiagnostic)this._diagnostics, event);
        if (filtered != null && !filtered.isEmpty()) {
            for (Diagnostic d : ((Diagnostic)this._diagnostics).getChildren()) {
                if (filtered.contains(d)) continue;
                diagnosticChain.add(d);
            }
        } else {
            return this._diagnostics;
        }
        return diagnosticChain;
    }

    protected Collection getFilteredDiagnostics(BasicDiagnostic diagnostics, TypedEvent event) {
        Diagnostic diag;
        ArrayList<Diagnostic> filtered = new ArrayList<Diagnostic>();
        if (event.widget == this._nameProvider.getNameControl() && (diag = DiagnosticUtil.getDiagnostic((String)Integer.toString(1), (BasicDiagnostic)diagnostics, (Object)this._mainObject)) != null) {
            filtered.add(diag);
        }
        return filtered;
    }

    protected void validateName(TypedEvent e) {
        if (this._nameChanged.booleanValue()) {
            SQLObject oldMainObject;
            DatabaseIdentifier databaseIdentifier;
            String quotedName;
            boolean success;
            String text = this._nameProvider.getNameControl().getText();
            this._mainObject.setName(text);
            this._nameChanged = Boolean.FALSE;
            boolean valid = false;
            this.validateAndShowErrors(e);
            Diagnostic d = DiagnosticUtil.getDiagnostic((String)Integer.toString(1), (BasicDiagnostic)((BasicDiagnostic)this._diagnostics), (Object)this._mainObject);
            if ((d == null || d.getSeverity() == 1 || d.getSeverity() == 2 || d.getSeverity() == 0) && (success = this._updater.updateName(quotedName = SQLUtil.quoteWhenNecessary(text, databaseIdentifier = SQLDevToolsUtil.getDatabaseIdentifier((SQLObject)(oldMainObject = this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject())))))) {
                boolean bl = true;
            }
        }
    }

    public boolean aboutToSave(IProgressMonitor monitor) {
        if (this._nameChanged.booleanValue()) {
            this._nameValidator.run();
        }
        return super.aboutToSave(monitor);
    }

    public void enable(boolean enabled) {
        this._enabled = enabled;
        if (!this.isPageOpened()) {
            return;
        }
        this._comp.setEnabled(this._enabled);
    }

    public void setFocus(int itemType, Object item) {
        if (item instanceof Trigger || item instanceof Routine || item instanceof org.eclipse.datatools.modelbase.sql.schema.Event) {
            this._nameProvider.getNameControl().forceFocus();
            this._nameProvider.getNameControl().selectAll();
        }
    }

    protected class NameValidator
    implements Runnable {
        protected NameValidator() {
        }

        public void run() {
            Event e = new Event();
            e.widget = ProceduralObjectGeneralPage.this._nameProvider.getNameControl();
            ProceduralObjectGeneralPage.this.validateName(new TypedEvent(e));
        }
    }
}

