/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.ddl;

import java.util.ArrayList;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheInfo;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumn;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEIndex;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionSegmentPair;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseIndexMember;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.common.util.EList;

public class ASEDdlUtils
implements IGenericDdlConstants,
ISybaseASEDdlConstants {
    public static String getCacheBindStatement(String cache, Index index, boolean qualifyNames, boolean fullSyntax, DatabaseIdentifier dbId) {
        StringBuffer statment = new StringBuffer();
        statment.append("EXEC sp_bindcache ");
        statment.append(String.valueOf(SQLUtil.quote((String)cache, (String)"'")) + "," + " ");
        statment.append(String.valueOf(SQLUtil.quote((String)index.getTable().getSchema().getCatalog().getName(), (String)"'")) + "," + " ");
        statment.append(String.valueOf(SQLUtil.quote((String)(String.valueOf(index.getTable().getSchema().getName()) + "." + index.getTable().getName()), (String)"'")) + "," + " ");
        statment.append(SQLUtil.quote((String)SQLDevToolsUtil.quoteWhenNecessary((String)index.getName(), (DatabaseIdentifier)dbId), (String)"'"));
        return statment.toString();
    }

    public static String getChangeAttributeStatement(String object, String attribute, String value) {
        StringBuffer statment = new StringBuffer();
        statment.append("EXEC sp_chgattribute ");
        statment.append(String.valueOf(object) + "," + " ");
        statment.append(String.valueOf(attribute) + "," + " ");
        statment.append(value);
        return statment.toString();
    }

    public static String getPartitionName(SybaseASEIndex index, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer result = new StringBuffer();
        EList list = index.getPartitions();
        int i = 0;
        while (i < list.size()) {
            PartitionSegmentPair partion = (PartitionSegmentPair)list.get(i);
            if (i > 0) {
                result.append(String.valueOf(NEWLINE) + "\t" + "," + " ");
            }
            result.append(partion.getPartitionName());
            if (partion.getSegment() != null) {
                result.append(" on " + SQLUtil.quote((String)partion.getSegment().getName(), (String)"'"));
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] getAllCacheStatement(SybaseASEIndex index, boolean qualifyNames, boolean fullSyntax, DatabaseIdentifier dbId) {
        CacheInfo cacheInfo = index.getCacheInfo();
        ArrayList<String> statements = new ArrayList<String>();
        if (cacheInfo != null && cacheInfo.getCache() != null) {
            statements.add(ASEDdlUtils.getCacheBindStatement(cacheInfo.getCache().getName(), (Index)index, qualifyNames, fullSyntax, dbId));
        }
        if (cacheInfo != null && cacheInfo.getCacheStrategy() >= 0) {
            int cacheStrategy = cacheInfo.getCacheStrategy();
            if ((cacheStrategy & 1) != 0 && fullSyntax) {
                statements.add(ASEDdlUtils.getCacheStrategyStatement("prefetch", (Index)index, true, dbId));
            }
            if ((cacheStrategy & 1) == 0) {
                statements.add(ASEDdlUtils.getCacheStrategyStatement("prefetch", (Index)index, false, dbId));
            }
            if ((cacheStrategy & 2) != 0 && fullSyntax) {
                statements.add(ASEDdlUtils.getCacheStrategyStatement("mru", (Index)index, true, dbId));
            }
            if ((cacheStrategy & 2) == 0) {
                statements.add(ASEDdlUtils.getCacheStrategyStatement("mru", (Index)index, false, dbId));
            }
        }
        return statements.toArray(new String[statements.size()]);
    }

    public static String getCacheStrategyStatement(String stragegy, Index index, boolean on, DatabaseIdentifier dbId) {
        StringBuffer statment = new StringBuffer();
        statment.append("EXEC sp_cachestrategy ");
        String databseName = index.getTable().getSchema().getCatalog().getName();
        statment.append(String.valueOf(SQLUtil.quote((String)databseName, (String)"'")) + "," + " ");
        String schemaName = index.getTable().getSchema().getName();
        statment.append(String.valueOf(SQLUtil.quote((String)(String.valueOf(schemaName) + "." + index.getTable().getName()), (String)"'")) + "," + " ");
        statment.append(SQLUtil.quote((String)SQLDevToolsUtil.quoteWhenNecessary((String)index.getName(), (DatabaseIdentifier)dbId), (String)"'"));
        statment.append(", " + SQLUtil.quote((String)stragegy, (String)"'") + "," + " ");
        statment.append(SQLUtil.quote((String)(on ? "on".toLowerCase() : "off".toLowerCase()), (String)"'"));
        return statment.toString();
    }

    public static String getIndexMemberKeys(EList members, boolean quoteIdentifiers) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < members.size()) {
            IndexMember m = (IndexMember)members.get(i);
            if (i == 0) {
                result.append(ASEDdlUtils.getIndexMember(quoteIdentifiers, m, false));
            } else {
                result.append(ASEDdlUtils.getIndexMember(quoteIdentifiers, m, true));
            }
            ++i;
        }
        return result.toString();
    }

    public static String getIndexMember(boolean quoteIdentifiers, IndexMember member, boolean hasComma) {
        StringBuffer result = new StringBuffer("");
        if (hasComma) {
            result.append(" , ");
        }
        if (member instanceof SybaseIndexMember) {
            boolean isHidden = false;
            if (member.getColumn() instanceof SybaseASEColumn) {
                isHidden = ((SybaseASEColumn)member.getColumn()).isHidden();
            }
            if (((SybaseIndexMember)member).getName() != null && !isHidden) {
                result.append(((SybaseIndexMember)member).getName());
            } else if (((SybaseIndexMember)member).getColumnExpression() != null && isHidden) {
                result.append(((SybaseIndexMember)member).getColumnExpression());
            } else if (((SybaseIndexMember)member).getColumnExpression() != null && member.getColumn() == null) {
                result.append(((SybaseIndexMember)member).getColumnExpression());
            }
        } else if (member.getColumn() != null) {
            if (quoteIdentifiers) {
                result.append(SQLUtil.quote((String)member.getColumn().getName(), (String)"\""));
            } else {
                result.append(member.getColumn().getName());
            }
        }
        result.append(" " + member.getIncrementType().getName());
        return result.toString();
    }
}

