/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;

public final class CatalogLoaderOverrideManager {
    public static final CatalogLoaderOverrideManager INSTANCE = new CatalogLoaderOverrideManager();
    private HashMap loaders = null;
    public final String EXT_PT_NS = "org.eclipse.datatools.connectivity.sqm.core";
    public final String EXT_PT_NAME = "catalog";
    public final String EXT_OVERRIDE = "overrideLoader";
    public final String EXT_PRODUCT = "product";
    public final String EXT_VERSION = "version";
    public final String EXT_ECLASS = "eclass";
    public final String EXT_PROVIDER = "provider";

    private CatalogLoaderOverrideManager() {
        this.loadExtensions();
    }

    private void loadExtensions() {
        if (this.loaders == null || this.loaders.size() == 0) {
            this.loaders = new HashMap();
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "catalog");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getName().equals("overrideLoader")) {
                        String product = configElements[j].getAttribute("product");
                        String version = configElements[j].getAttribute("version");
                        String eclassName = configElements[j].getAttribute("eclass");
                        String providerClassName = configElements[j].getAttribute("provider");
                        try {
                            JDBCBaseLoader tempLoader = (JDBCBaseLoader)configElements[j].createExecutableExtension("provider");
                            LoaderDetails details = new LoaderDetails(product, version, eclassName, tempLoader);
                            DatabaseDefinition definition = details.defn;
                            if (this.loaders.containsKey(definition)) {
                                ((Map)this.loaders.get(definition)).put(eclassName, details);
                            } else {
                                TreeMap<String, LoaderDetails> eClasses = new TreeMap<String, LoaderDetails>();
                                eClasses.put(eclassName, details);
                                this.loaders.put(definition, eClasses);
                            }
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "An error was detected when creating the override catalog loader (" + providerClassName + ") for " + eclassName + " for database " + product + " " + version, (Throwable)e);
                            RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public JDBCBaseLoader getLoaderForDatabase(DatabaseDefinition defn, String eClassName) {
        Map eClasses;
        if (this.loaders.containsKey(defn) && (eClasses = (Map)this.loaders.get(defn)) != null && eClasses.containsKey(eClassName)) {
            LoaderDetails details = (LoaderDetails)eClasses.get(eClassName);
            JDBCBaseLoader loader = details.loader;
            if (loader != null) {
                try {
                    loader = (JDBCBaseLoader)loader.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return loader;
        }
        return null;
    }

    public Iterator getDbDefinitions() {
        return this.loaders.keySet().iterator();
    }

    public Iterator getEClasses(DatabaseDefinition defn) {
        Map eClasses = (Map)this.loaders.get(defn);
        if (eClasses == null) {
            return new TreeMap().keySet().iterator();
        }
        return eClasses.keySet().iterator();
    }

    public CatalogLoaderOverrideManager getInstance() {
        return INSTANCE;
    }

    private class LoaderDetails {
        protected String vendor;
        protected String version;
        protected String keyObject;
        protected JDBCBaseLoader loader;
        protected DatabaseDefinition defn;

        public LoaderDetails() {
            this.vendor = null;
            this.version = null;
            this.keyObject = null;
            this.loader = null;
            this.defn = null;
        }

        public LoaderDetails(String vendor, String version, String key, JDBCBaseLoader loader) {
            this.vendor = vendor;
            this.version = version;
            this.keyObject = key;
            this.loader = loader;
            DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(vendor, version);
            if (def != null) {
                this.defn = def;
            }
        }
    }
}

