/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.treeplan;

import java.util.List;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComponent;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComposite;

public class PlanTreeBuilder {
    TreePlanNodeComponent _rootNode;
    TreePlanNodeComponent _currentNode;

    public PlanTreeBuilder() {
        this._currentNode = this._rootNode = new TreePlanNodeComposite();
    }

    public PlanTreeBuilder(String name, String tip, String detail, Object data, String label1, boolean isLabel1Highlighted, String label2, boolean isLabel2Highlighted) {
        this._currentNode = this._rootNode = new TreePlanNodeComposite(name, tip, detail, data, label1, isLabel1Highlighted, label2, isLabel2Highlighted, null);
    }

    public TreePlanNodeComponent getCurrentNode() {
        return this._currentNode;
    }

    public TreePlanNodeComponent getRoot() {
        return this._rootNode;
    }

    public boolean addChild(String name, String tip, String detail, Object data, String label1, boolean isLabel1Highlighted, String label2, boolean isLabel2Highlighted) {
        if (this._currentNode == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite(name, tip, detail, data, label1, isLabel1Highlighted, label2, isLabel2Highlighted, this._currentNode);
        this._currentNode.addChild(node);
        this._currentNode = node;
        return true;
    }

    public boolean addChild() {
        if (this._currentNode == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite();
        this._currentNode.addChild(node);
        node.setParent(this._currentNode);
        this._currentNode = node;
        return true;
    }

    public boolean addSibling(String name, String tip, String detail, Object data, String label1, boolean isLabel1Highlighted, String label2, boolean isLabel2Highlighted) {
        if (this._currentNode == null) {
            return false;
        }
        if (this._currentNode.getParent() == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite(name, tip, detail, data, label1, isLabel1Highlighted, label2, isLabel2Highlighted, this._currentNode.getParent());
        this._currentNode.getParent().addChild(node);
        this._currentNode = node;
        return true;
    }

    public boolean addSibling() {
        if (this._currentNode == null) {
            return false;
        }
        if (this._currentNode.getParent() == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite();
        node.setParent(this._currentNode.getParent());
        this._currentNode.getParent().addChild(node);
        this._currentNode = node;
        return true;
    }

    public boolean addTo(TreePlanNodeComponent parent, String name, String tip, String detail, Object data, String label1, boolean isLabel1Highlighted, String label2, boolean isLabel2Highlighted) {
        if (parent == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite(name, tip, detail, data, label1, isLabel1Highlighted, label2, isLabel2Highlighted, parent);
        parent.addChild(node);
        this._currentNode = node;
        return true;
    }

    public boolean addTo(TreePlanNodeComponent parent) {
        if (parent == null) {
            return false;
        }
        TreePlanNodeComposite node = new TreePlanNodeComposite();
        parent.addChild(node);
        node.setParent(parent);
        this._currentNode = node;
        return true;
    }

    public void findNodes(String name, List nodes) {
        this.findNodes(name, nodes, this._rootNode);
    }

    protected void findNodes(String name, List nodes, TreePlanNodeComponent node) {
        if (name == null || nodes == null) {
            return;
        }
        if (node != null && node.getName() != null && node.getName().equals(name)) {
            nodes.add(node);
        }
        if (node.getChildren() == null) {
            return;
        }
        for (TreePlanNodeComponent n : node.getChildren()) {
            this.findNodes(name, nodes, n);
        }
    }
}

