/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table _table;
    TableItem _row = null;
    TableColumn _column = null;
    Listener _tableListener;
    Listener _resizeListener;
    Listener _disposeItemListener;
    Listener _disposeColumnListener;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TableCursor(Table parent, int style) {
        super((Composite)parent, style);
        ScrollBar vBar;
        this._table = parent;
        this.setBackground(null);
        this.setForeground(null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableCursor.this.dispose(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TableCursor.this.redraw();
                        break;
                    }
                    case 1: {
                        TableCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TableCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TableCursor.this.traverse(event);
                    }
                }
            }
        };
        int[] events = new int[]{12, 15, 16, 1, 9, 31};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        this._tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TableCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this._table.addListener(15, this._tableListener);
        this._table.addListener(3, this._tableListener);
        this._disposeItemListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this._row = null;
                TableCursor.this._column = null;
                TableCursor.this.resize();
            }
        };
        this._disposeColumnListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this._row = null;
                TableCursor.this._column = null;
                TableCursor.this.resize();
            }
        };
        this._resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.resize();
            }
        };
        ScrollBar hBar = this._table.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this._resizeListener);
        }
        if ((vBar = this._table.getVerticalBar()) != null) {
            vBar.addListener(13, this._resizeListener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void dispose(Event event) {
        ScrollBar vBar;
        ScrollBar hBar;
        this._table.removeListener(15, this._tableListener);
        this._table.removeListener(3, this._tableListener);
        if (this._column != null) {
            this._column.removeListener(12, this._disposeColumnListener);
            this._column.removeListener(10, this._resizeListener);
            this._column.removeListener(11, this._resizeListener);
            this._column = null;
        }
        if (this._row != null) {
            this._row.removeListener(12, this._disposeItemListener);
            this._row = null;
        }
        if ((hBar = this._table.getHorizontalBar()) != null) {
            hBar.removeListener(13, this._resizeListener);
        }
        if ((vBar = this._table.getVerticalBar()) != null) {
            vBar.removeListener(13, this._resizeListener);
        }
    }

    void keyDown(Event event) {
        if (this._row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        int rowIndex = this._table.indexOf(this._row);
        int columnIndex = this._column == null ? 0 : this._table.indexOf(this._column);
        switch (event.keyCode) {
            case 0x1000001: {
                this.setRowColumn(Math.max(0, rowIndex - 1), columnIndex, true);
                break;
            }
            case 0x1000002: {
                this.setRowColumn(Math.min(rowIndex + 1, this._table.getItemCount() - 1), columnIndex, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int leadKey;
                int columnCount = this._table.getColumnCount();
                if (columnCount == 0) break;
                int[] order = this._table.getColumnOrder();
                int index = 0;
                while (index < order.length) {
                    if (order[index] == columnIndex) break;
                    ++index;
                }
                if (index == order.length) {
                    index = 0;
                }
                int n = leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == leadKey) {
                    this.setRowColumn(rowIndex, order[Math.max(0, index - 1)], true);
                    break;
                }
                this.setRowColumn(rowIndex, order[Math.min(columnCount - 1, index + 1)], true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(0, columnIndex, true);
                break;
            }
            case 0x1000008: {
                int i = this._table.getItemCount() - 1;
                this.setRowColumn(i, columnIndex, true);
                break;
            }
            case 0x1000005: {
                int index = this._table.getTopIndex();
                if (index == rowIndex) {
                    Rectangle rect = this._table.getClientArea();
                    TableItem item = this._table.getItem(index);
                    Rectangle itemRect = item.getBounds(0);
                    rect.height -= itemRect.y;
                    int height = this._table.getItemHeight();
                    int page = Math.max(1, rect.height / height);
                    index = Math.max(0, index - page + 1);
                }
                this.setRowColumn(index, columnIndex, true);
                break;
            }
            case 0x1000006: {
                int index = this._table.getTopIndex();
                Rectangle rect = this._table.getClientArea();
                TableItem item = this._table.getItem(index);
                Rectangle itemRect = item.getBounds(0);
                rect.height -= itemRect.y;
                int height = this._table.getItemHeight();
                int page = Math.max(1, rect.height / height);
                int end = this._table.getItemCount() - 1;
                index = Math.min(end, index + page - 1);
                if (index == rowIndex) {
                    index = Math.min(end, index + page - 1);
                }
                this.setRowColumn(index, columnIndex, true);
            }
        }
    }

    void paint(Event event) {
        String text;
        if (this._row == null) {
            return;
        }
        int columnIndex = this._column == null ? 0 : this._table.indexOf(this._column);
        GC gc = event.gc;
        Display display = this.getDisplay();
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        int x = 0;
        Point size = this.getSize();
        Image image = this._row.getImage(columnIndex);
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x, imageY);
            x += imageSize.width;
        }
        if ((text = this._row.getText(columnIndex)) != "") {
            int alignmnent;
            Rectangle bounds = this._row.getBounds(columnIndex);
            Point extent = gc.stringExtent(text);
            String platform = SWT.getPlatform();
            if ("win32".equals(platform)) {
                if (this._table.getColumnCount() == 0 || columnIndex == 0) {
                    x += 2;
                } else {
                    alignmnent = this._column.getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x += 6;
                            break;
                        }
                        case 131072: {
                            x = bounds.width - extent.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            x += (bounds.width - x - extent.x) / 2;
                        }
                    }
                }
            } else if (this._table.getColumnCount() == 0) {
                x += 5;
            } else {
                alignmnent = this._column.getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x += 5;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x += (bounds.width - x - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text, x, textY);
        }
        if (this.isFocusControl()) {
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        Rectangle clientRect = this._table.getClientArea();
        int columnCount = this._table.getColumnCount();
        int maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        int start = this._table.getTopIndex();
        int end = this._table.getItemCount();
        int i = start;
        while (i < end) {
            TableItem item = this._table.getItem(i);
            int j = 0;
            while (j <= maxColumnIndex) {
                Rectangle rect = item.getBounds(j);
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                if (rect.contains(pt)) {
                    this.setRowColumn(i, j, true);
                    this.setFocus();
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    void setRowColumn(int row, int column, boolean notify) {
        TableItem item = row == -1 ? null : this._table.getItem(row);
        TableColumn col = column == -1 || this._table.getColumnCount() == 0 ? null : this._table.getColumn(column);
        this.setRowColumn(item, col, notify);
    }

    void setRowColumn(TableItem row, TableColumn column, boolean notify) {
        if (this._table.indexOf(column) == 0) {
            column = this._table.getColumn(this._table.indexOf(column) + 1);
        }
        if (this._row == row && this._column == column) {
            return;
        }
        if (this._row != null && this._row != row) {
            this._row.removeListener(12, this._disposeItemListener);
            this._row = null;
        }
        if (this._column != null && this._column != column) {
            this._column.removeListener(12, this._disposeColumnListener);
            this._column.removeListener(10, this._resizeListener);
            this._column.removeListener(11, this._resizeListener);
            this._column = null;
        }
        if (row != null) {
            if (this._row != row) {
                this._row = row;
                row.addListener(12, this._disposeItemListener);
                this._table.showItem(row);
            }
            if (this._column != column && column != null) {
                this._column = column;
                column.addListener(12, this._disposeColumnListener);
                column.addListener(10, this._resizeListener);
                column.addListener(11, this._resizeListener);
                this._table.showColumn(column);
            }
            int columnIndex = column == null ? 0 : this._table.indexOf(column);
            this.setBounds(row.getBounds(columnIndex));
            this.redraw();
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this.resize();
        }
        super.setVisible(visible);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    void resize() {
        if (this._row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int columnIndex = this._column == null ? 0 : this._table.indexOf(this._column);
            this.setBounds(this._row.getBounds(columnIndex));
        }
    }

    public int getColumn() {
        this.checkWidget();
        return this._column == null ? 0 : this._table.indexOf(this._column);
    }

    public TableItem getRow() {
        this.checkWidget();
        return this._row;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(27);
        }
        super.setBackground(color);
        this.redraw();
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(26);
        }
        super.setForeground(color);
        this.redraw();
    }

    public void setSelection(int row, int column) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this._table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row < 0 || row >= this._table.getItemCount() || column < 0 || column > maxColumnIndex) {
            SWT.error((int)5);
        }
        this.setRowColumn(row, column, false);
    }

    public void setSelection(TableItem row, int column) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this._table.getColumnCount();
        int n = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row == null || row.isDisposed() || column < 0 || column > maxColumnIndex) {
            SWT.error((int)5);
        }
        this.setRowColumn(this._table.indexOf(row), column, false);
    }
}

