/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.enablement.oda.xml.util.AnyNumberElementPlaceholderNode;
import org.eclipse.datatools.enablement.oda.xml.util.AttrNode;
import org.eclipse.datatools.enablement.oda.xml.util.ElementNode;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLPathNode;
import org.eclipse.datatools.enablement.oda.xml.util.OneElementPlaceholderNode;
import org.eclipse.datatools.enablement.oda.xml.util.TreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.XMLAttr;

abstract class ChildrenAllowedTreeNode
extends TreeNode {
    private AnyNumberElementPlaceholderNode anyNumberElementChild = null;
    private OneElementPlaceholderNode oneElementChild = null;
    private Map attrChildren = new HashMap();
    private Map elementChildren = new HashMap();
    private boolean hasChild = false;

    public ChildrenAllowedTreeNode(String pathElementName) {
        super(pathElementName);
    }

    protected TreeNode addChild(String pathElement) {
        assert (pathElement != null);
        if (pathElement.equals("<>")) {
            if (this.anyNumberElementChild == null) {
                this.anyNumberElementChild = new AnyNumberElementPlaceholderNode();
                this.anyNumberElementChild.setParent(this);
            }
            this.hasChild = true;
            return this.anyNumberElementChild;
        }
        if (pathElement.equals("*")) {
            if (this.oneElementChild == null) {
                this.oneElementChild = new OneElementPlaceholderNode();
                this.oneElementChild.setParent(this);
            }
            this.hasChild = true;
            return this.oneElementChild;
        }
        if (pathElement.startsWith("@")) {
            String attrName = pathElement.substring(1);
            TreeNode existNode = (TreeNode)this.attrChildren.get(attrName);
            if (existNode == null) {
                existNode = new AttrNode(attrName);
                existNode.setParent(this);
                this.attrChildren.put(attrName, existNode);
            }
            this.hasChild = true;
            return existNode;
        }
        TreeNode existNode = null;
        String pureElement = pathElement.replaceAll("\\Q[\\E\\d+\\Q]\\E$", "");
        HashSet<ElementNode> elementNodes = (HashSet<ElementNode>)this.elementChildren.get(pureElement);
        if (elementNodes == null) {
            elementNodes = new HashSet<ElementNode>();
            this.elementChildren.put(pureElement, elementNodes);
        }
        for (TreeNode treeNode : elementNodes) {
            if (!treeNode.getPathElemntName().equals(pathElement)) continue;
            existNode = treeNode;
            break;
        }
        if (existNode == null) {
            existNode = new ElementNode(pathElement);
            existNode.setParent(this);
            elementNodes.add((ElementNode)existNode);
        }
        this.hasChild = true;
        return existNode;
    }

    protected boolean hasChild() {
        return this.hasChild;
    }

    protected TreeNode getAnyNumberElementChild() {
        return this.anyNumberElementChild;
    }

    public Set getMatchedDownables(IXMLPathNode xpn) {
        assert (xpn != null);
        HashSet<TreeNode> result = new HashSet<TreeNode>();
        if (xpn instanceof XMLAttr) {
            TreeNode node;
            if (this.anyNumberElementChild != null) {
                result.addAll(this.anyNumberElementChild.getMatchedDownables(xpn));
            }
            if ((node = (TreeNode)this.attrChildren.get(xpn.getName())) != null) {
                result.add(node);
            }
        } else {
            Set elementNodes;
            if (this.anyNumberElementChild != null) {
                result.add(this.anyNumberElementChild);
                result.addAll(this.anyNumberElementChild.getMatchedDownables(xpn));
            }
            if (this.oneElementChild != null) {
                result.add(this.oneElementChild);
            }
            if ((elementNodes = (Set)this.elementChildren.get(xpn.getName())) != null) {
                for (TreeNode elementNode : elementNodes) {
                    if (!elementNode.matches(xpn)) continue;
                    result.add(elementNode);
                }
            }
        }
        return result;
    }
}

