/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class CommitSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String COMMIT_SELECTION_DIALOG_SECTION = "CommitSelectionDialogSection";
    private CommitLabelProvider labelProvider;

    public CommitSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setTitle(UIText.CommitSelectionDialog_Title);
        this.setMessage(UIText.CommitSelectionDialog_Message);
        this.labelProvider = new CommitLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new GitLabelProvider(){

            @Override
            public Image getImage(Object element) {
                if (element instanceof RepositoryCommit) {
                    RepositoryCommit commit = (RepositoryCommit)((Object)element);
                    return super.getImage(commit.getRepository());
                }
                return super.getImage(element);
            }

            @Override
            public String getText(Object element) {
                if (element instanceof RepositoryCommit) {
                    RepositoryCommit commit = (RepositoryCommit)((Object)element);
                    return super.getText(commit.getRepository());
                }
                return super.getText(element);
            }
        });
        this.setInitialPattern("HEAD", 2);
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(displayArea);
        Link link = new Link(displayArea, 0);
        link.setText(UIText.CommitSelectionDialog_LinkSearch);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSelectionDialog.this.close();
                NewSearchUI.openSearchDialog((IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (String)"org.eclipse.egit.ui.commitSearchPage");
            }
        });
        return displayArea;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(COMMIT_SELECTION_DIALOG_SECTION);
        if (section == null) {
            section = settings.addNewSection(COMMIT_SELECTION_DIALOG_SECTION);
        }
        return section;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                return false;
            }

            public boolean matchItem(Object item) {
                return true;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return Comparator.comparing(RepositoryCommit::getRepositoryName, String.CASE_INSENSITIVE_ORDER).thenComparing(RepositoryCommit::getRevCommit);
    }

    private Repository[] getRepositories() {
        return RepositoryCache.getInstance().getAllRepositories();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        String pattern = itemsFilter.getPattern();
        Repository[] repositories = this.getRepositories();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)repositories.length);
        progress.setTaskName(UIText.CommitSelectionDialog_TaskSearching);
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Repository repository = repositoryArray[n2];
                try {
                    ObjectId commitId = ObjectId.isId((String)pattern) ? ObjectId.fromString((String)pattern) : repository.resolve(itemsFilter.getPattern());
                    if (commitId == null) break block13;
                    Throwable throwable = null;
                    Object var13_16 = null;
                    try (RevWalk walk = new RevWalk(repository);){
                        walk.setRetainBody(true);
                        RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
                        contentProvider.add((Object)new RepositoryCommit(repository, commit), itemsFilter);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (RevisionSyntaxException revisionSyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            progress.worked(1);
            ++n2;
        }
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.CommitSelectionDialog_ButtonOK, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private static class CommitLabelProvider
    extends GitLabelProvider {
        private CommitLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString styled = new StyledString();
            if (element instanceof RepositoryCommit) {
                RepositoryCommit commit = (RepositoryCommit)((Object)element);
                styled.append(commit.abbreviate());
                styled.append(MessageFormat.format(UIText.CommitSelectionDialog_SectionMessage, commit.getRevCommit().getShortMessage()), StyledString.QUALIFIER_STYLER);
                styled.append(MessageFormat.format(UIText.CommitSelectionDialog_SectionRepo, commit.getRepositoryName()), StyledString.DECORATIONS_STYLER);
            } else if (element != null) {
                styled.append(element.toString());
            }
            return styled;
        }
    }
}

