/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.English;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class EnglishRedundancyRule
extends AbstractSimpleReplaceRule2 {
    public static final String EN_REDUNDANCY_REPLACE = "EN_REDUNDANCY_REPLACE";
    private static final String FILE_NAME = "/en/redundancies.txt";
    private static final Locale EN_LOCALE = new Locale("en");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public EnglishRedundancyRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new English());
        this.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
        this.addExamplePair(Example.wrong((String)"<marker>tuna fish</marker>"), Example.fixed((String)"<marker>tuna</marker>"));
    }

    public final String getId() {
        return EN_REDUNDANCY_REPLACE;
    }

    public String getDescription() {
        return "1. Redundancy (General)";
    }

    public String getShort() {
        return "Redundancy";
    }

    public String getMessage() {
        return "'$match' is a redundancy. In some cases, it might be preferable to use $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " or ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://en.wikipedia.org/wiki/Redundancy_(linguistics)");
    }

    public Locale getLocale() {
        return EN_LOCALE;
    }
}

