/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ObjectProperty
extends AbstractProperty
implements Property {
    public static final String TYPE = "object";
    Map<String, Property> properties;

    public ObjectProperty() {
        this.type = TYPE;
    }

    public ObjectProperty(Map<String, Property> properties) {
        this.type = TYPE;
        this.properties = properties;
    }

    public ObjectProperty vendorExtension(String key, Object obj) {
        this.setVendorExtension(key, obj);
        return this;
    }

    public static boolean isType(String type) {
        return TYPE.equals(type);
    }

    public static boolean isType(String type, String format) {
        return ObjectProperty.isType(type);
    }

    public ObjectProperty properties(Map<String, Property> properties) {
        this.setProperties(properties);
        return this;
    }

    public ObjectProperty property(String name, Property property) {
        if (this.properties == null) {
            this.properties = new TreeMap<String, Property>();
        }
        this.properties.put(name, property);
        return this;
    }

    public ObjectProperty access(String access) {
        this.setAccess(access);
        return this;
    }

    @Override
    public ObjectProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    public ObjectProperty name(String name) {
        this.setName(name);
        return this;
    }

    @Override
    public ObjectProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    public ObjectProperty _default(String _default) {
        this.setDefault(_default);
        return this;
    }

    public ObjectProperty readOnly(boolean readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public ObjectProperty required(boolean required) {
        this.setRequired(required);
        return this;
    }

    @Override
    public ObjectProperty readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @JsonGetter(value="required")
    public List<String> getRequiredProperties() {
        ArrayList<String> output = new ArrayList<String>();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                Property prop = this.properties.get(key);
                if (prop == null || !prop.getRequired()) continue;
                output.add(key);
            }
        }
        Collections.sort(output);
        if (output.size() > 0) {
            return output;
        }
        return null;
    }

    @JsonSetter(value="required")
    public void setRequiredProperties(List<String> required) {
        if (this.properties != null) {
            for (String s2 : required) {
                Property p = this.properties.get(s2);
                if (p == null) continue;
                p.setRequired(true);
            }
        }
    }

    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    public ObjectProperty xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public ObjectProperty example(Object example) {
        this.setExample(example);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectProperty)) {
            return false;
        }
        ObjectProperty that = (ObjectProperty)o;
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

