Contributing
============

Thanks for your interest in contributing to the Tiny Tiny RSS (tt-rss) project!  Contributions are welcome.

Here are some ideas to get you started:

* Help others, especially those getting started with tt-rss.
* [Report issues](https://github.com/tt-rss/tt-rss/issues), and/or help troubleshoot issues (e.g. confirm the issue, provide additional information,
  identify as a duplicate issue, etc.).
* Help improve the documentation.
  * For now this is in two places: [this project's wiki](https://github.com/tt-rss/tt-rss/wiki) and
    https://github.com/tt-rss/tt-rss.github.io (content backing https://tt-rss.org; converted from the aforementioned wiki content).
    The long-term plan is to fully switch to the latter, enabling direct contributions.
* Help improve the translations [via Weblate](https://hosted.weblate.org/engage/tt-rss/).
  * Related: If something shows up in tt-rss and isn't making its way into Weblate, [report the issue](https://github.com/tt-rss/tt-rss/issues)
    so translation coverage can (potentially) be improved.
* Help improve the code.
  * Development primarily happens in https://github.com/tt-rss/tt-rss, but some plugins are in their own repository under https://github.com/tt-rss/.
  * Keep in mind major changes (particularly to the user experience) are unlikely to be accepted unless discussed and agreed upon beforehand.
    Plugins, etc. are generally preferred over modifying the core project when customization is desired.
  * If there are any questions about whether something would be accepted, it'd be best to first
    [start a discussion](https://github.com/tt-rss/tt-rss/discussions) or [open an issue](https://github.com/tt-rss/tt-rss/issues).
