/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.mapping.DynamicMapping;
import org.opensearch.client.opensearch._types.mapping.DynamicTemplate;
import org.opensearch.client.opensearch._types.mapping.FieldNamesField;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.RoutingField;
import org.opensearch.client.opensearch._types.mapping.SourceField;
import org.opensearch.client.opensearch.indices.PutMappingResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutMappingRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutMappingRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final DynamicMapping dynamic;
    @Nonnull
    private final List<String> dynamicDateFormats;
    @Nonnull
    private final List<Map<String, DynamicTemplate>> dynamicTemplates;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final FieldNamesField fieldNames;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean numericDetection;
    @Nonnull
    private final Map<String, Property> properties;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SourceField source;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean writeIndexOnly;
    public static final JsonpDeserializer<PutMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutMappingRequest::setupPutMappingRequestDeserializer);
    public static final Endpoint<PutMappingRequest, PutMappingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutMappingRequest, PutMappingResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
        buf.append("/_mapping");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutMappingResponse._DESERIALIZER);

    private PutMappingRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ApiTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ApiTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.fieldNames = builder.fieldNames;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.numericDetection = builder.numericDetection;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.routing = builder.routing;
        this.source = builder.source;
        this.timeout = builder.timeout;
        this.writeIndexOnly = builder.writeIndexOnly;
    }

    public static PutMappingRequest of(Function<Builder, ObjectBuilder<PutMappingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    @Nonnull
    public final List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    @Nonnull
    public final List<Map<String, DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean numericDetection() {
        return this.numericDetection;
    }

    @Nonnull
    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public final RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public final SourceField source() {
        return this.source;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean writeIndexOnly() {
        return this.writeIndexOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection.booleanValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.dynamicDateFormats)) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dynamicTemplates)) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (Map map : this.dynamicTemplates) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((DynamicTemplate)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutMappingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection");
        op.add(Builder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats");
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(DynamicTemplate._DESERIALIZER)), "dynamic_templates");
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection");
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing");
        op.add(Builder::source, SourceField._DESERIALIZER, "_source");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.writeIndexOnly != null) {
            params.put("write_index_only", String.valueOf(this.writeIndexOnly));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.dateDetection);
        result = 31 * result + Objects.hashCode(this.dynamic);
        result = 31 * result + Objects.hashCode(this.dynamicDateFormats);
        result = 31 * result + Objects.hashCode(this.dynamicTemplates);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.fieldNames);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.numericDetection);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.writeIndexOnly);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMappingRequest other = (PutMappingRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.dateDetection, other.dateDetection) && Objects.equals(this.dynamic, other.dynamic) && Objects.equals(this.dynamicDateFormats, other.dynamicDateFormats) && Objects.equals(this.dynamicTemplates, other.dynamicTemplates) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.fieldNames, other.fieldNames) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && this.index.equals(other.index) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.meta, other.meta) && Objects.equals(this.numericDetection, other.numericDetection) && Objects.equals(this.properties, other.properties) && Objects.equals(this.routing, other.routing) && Objects.equals(this.source, other.source) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.writeIndexOnly, other.writeIndexOnly);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutMappingRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<Map<String, DynamicTemplate>> dynamicTemplates;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SourceField source;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean writeIndexOnly;

        public Builder() {
        }

        private Builder(PutMappingRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.dateDetection = o.dateDetection;
            this.dynamic = o.dynamic;
            this.dynamicDateFormats = Builder._listCopy(o.dynamicDateFormats);
            this.dynamicTemplates = Builder._listCopy(o.dynamicTemplates);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.fieldNames = o.fieldNames;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.numericDetection = o.numericDetection;
            this.properties = Builder._mapCopy(o.properties);
            this.routing = o.routing;
            this.source = o.source;
            this.timeout = o.timeout;
            this.writeIndexOnly = o.writeIndexOnly;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.dateDetection = o.dateDetection;
            this.dynamic = o.dynamic;
            this.dynamicDateFormats = Builder._listCopy(o.dynamicDateFormats);
            this.dynamicTemplates = Builder._listCopy(o.dynamicTemplates);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.fieldNames = o.fieldNames;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.numericDetection = o.numericDetection;
            this.properties = Builder._mapCopy(o.properties);
            this.routing = o.routing;
            this.source = o.source;
            this.timeout = o.timeout;
            this.writeIndexOnly = o.writeIndexOnly;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        @Nonnull
        public final Builder dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return this;
        }

        @Nonnull
        public final Builder dynamicDateFormats(List<String> list) {
            this.dynamicDateFormats = Builder._listAddAll(this.dynamicDateFormats, list);
            return this;
        }

        @Nonnull
        public final Builder dynamicDateFormats(String value, String ... values) {
            this.dynamicDateFormats = Builder._listAdd(this.dynamicDateFormats, value, values);
            return this;
        }

        @Nonnull
        public final Builder dynamicTemplates(List<Map<String, DynamicTemplate>> list) {
            this.dynamicTemplates = Builder._listAddAll(this.dynamicTemplates, list);
            return this;
        }

        @Nonnull
        public final Builder dynamicTemplates(Map<String, DynamicTemplate> value, Map<String, DynamicTemplate> ... values) {
            this.dynamicTemplates = Builder._listAdd(this.dynamicTemplates, value, values);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        @Nonnull
        public final Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        @Nonnull
        public final Builder properties(Map<String, Property> map) {
            this.properties = Builder._mapPutAll(this.properties, map);
            return this;
        }

        @Nonnull
        public final Builder properties(String key, Property value) {
            this.properties = Builder._mapPut(this.properties, key, value);
            return this;
        }

        @Nonnull
        public final Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        @Nonnull
        public final Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        @Nonnull
        public final Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder writeIndexOnly(@Nullable Boolean value) {
            this.writeIndexOnly = value;
            return this;
        }

        @Override
        @Nonnull
        public PutMappingRequest build() {
            this._checkSingleUse();
            return new PutMappingRequest(this);
        }
    }
}

