/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;

public class DarkModeDetector {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    public static boolean isDarkMode() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return DarkModeDetector.isMacOsDarkMode();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return DarkModeDetector.isWindowsDarkMode();
        }
        if (SystemUtils.IS_OS_LINUX && DarkModeDetector.isGnome()) {
            return DarkModeDetector.isGnomeDarkMode();
        }
        return false;
    }

    private static boolean isGnome() {
        String currentDesktop = System.getenv("XDG_CURRENT_DESKTOP");
        return currentDesktop != null && (currentDesktop.equals("GNOME") || currentDesktop.equals("ubuntu:GNOME"));
    }

    public static boolean hasDarkModeDetectionSupport() {
        return SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_LINUX && DarkModeDetector.isGnome();
    }

    private static boolean isGnomeDarkMode() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"gsettings", "get", "org.gnome.desktop.interface", "color-scheme"});
            StringWriter buffer = new StringWriter();
            try (InputStreamReader source = new InputStreamReader(process.getInputStream());){
                source.transferTo(buffer);
            }
            boolean rc = process.waitFor(5L, TimeUnit.SECONDS);
            return rc && buffer.toString().trim().equals("'prefer-dark'");
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMacOsDarkMode() {
        BufferedReader rdr = null;
        InputStreamReader isr = null;
        try {
            String line;
            boolean isDarkMode = false;
            Process process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            isr = new InputStreamReader(process.getInputStream());
            rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            boolean bl = 0 == rc && isDarkMode;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isWindowsDarkMode() {
        try {
            Process process = Runtime.getRuntime().exec(DARK_THEME_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return false;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class StreamReader
    extends Thread {
        private final InputStream is;
        private final StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

