/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.lang.Args;

public class FormComponentLabel
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    public static final String REQUIRED_CSS_CLASS_KEY = CssUtils.key(FormComponentLabel.class, "required");
    public static final String INVALID_CSS_CLASS_KEY = CssUtils.key(FormComponentLabel.class, "invalid");
    public static final String DISABLED_CSS_CLASS_KEY = CssUtils.key(FormComponentLabel.class, "disabled");
    private final LabeledWebMarkupContainer component;

    public FormComponentLabel(String id, LabeledWebMarkupContainer component) {
        super(id);
        this.component = (LabeledWebMarkupContainer)Args.notNull((Object)component, (String)"component");
        component.setOutputMarkupId(true);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "label");
        LabeledWebMarkupContainer formComponent = this.getFormComponent();
        tag.put("for", formComponent.getMarkupId());
        if (formComponent instanceof FormComponent) {
            FormComponent fc = (FormComponent)formComponent;
            if (fc.isRequired()) {
                tag.append("class", this.getString(REQUIRED_CSS_CLASS_KEY), " ");
            }
            if (!fc.isValid()) {
                tag.append("class", this.getString(INVALID_CSS_CLASS_KEY), " ");
            }
        }
        if (!formComponent.isEnabledInHierarchy()) {
            tag.append("class", this.getString(DISABLED_CSS_CLASS_KEY), " ");
        }
        tag.setType(XmlTag.TagType.OPEN);
    }

    public LabeledWebMarkupContainer getFormComponent() {
        return this.component;
    }
}

