/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.api.entity.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;

public class PropagationData implements Serializable {

    private static final long serialVersionUID = -6193849782964810456L;

    private final Set<Attribute> attributes;

    private Set<AttributeDelta> attributeDeltas;

    @JsonCreator
    public PropagationData(@JsonProperty("attributes") final Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Set<Attribute> getAttributes() {
        return attributes;
    }

    public Set<AttributeDelta> getAttributeDeltas() {
        return attributeDeltas;
    }

    public void setAttributeDeltas(final Set<AttributeDelta> attributeDeltas) {
        this.attributeDeltas = attributeDeltas;
    }

    @Override
    public String toString() {
        return "PropagationData{"
                + "attributes=" + attributes
                + ", attributeDeltas=" + attributeDeltas + '}';
    }
}
