/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.atomic.LongAdder;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;

@MBean(description="Fragments messages larger than fragmentation size into smaller messages")
public class Fragmentation
extends Protocol {
    @Property(description="The max number of bytes in a message. Larger messages will be fragmented", type=AttributeType.BYTES)
    protected int frag_size = 60000;
    protected LongAdder num_frags_sent = new LongAdder();
    protected LongAdder num_frags_received = new LongAdder();

    public int getFragSize() {
        return this.frag_size;
    }

    public <T extends Fragmentation> T setFragSize(int f) {
        this.frag_size = f;
        return (T)this;
    }

    @ManagedAttribute(description="Number of sent fragments", type=AttributeType.SCALAR)
    public long getNumberOfSentFragments() {
        return this.num_frags_sent.sum();
    }

    @ManagedAttribute(description="Number of received fragments", type=AttributeType.SCALAR)
    public long getNumberOfReceivedFragments() {
        return this.num_frags_received.sum();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_frags_sent.reset();
        this.num_frags_received.reset();
    }
}

