/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import java.util.List;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationAggregate;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.RegisterConfigurationCommand;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class RegisterConfigurationCommandHandler
implements CommandHandler<RegisterConfigurationCommand> {
    private final EventStore eventStore;

    RegisterConfigurationCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public Class<RegisterConfigurationCommand> handledClass() {
        return RegisterConfigurationCommand.class;
    }

    public Publisher<List<EventWithState>> handle(RegisterConfigurationCommand command) {
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate(command.getAggregateId())).map(history -> ConfigurationAggregate.load(command.getAggregateId(), history).registerConfiguration(command.getConfiguration()));
    }
}

