/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionEnd;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionWithLanguage;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionWithNullOption;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionWithType;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateDseFunction
implements CreateDseFunctionEnd,
CreateDseFunctionStart,
CreateDseFunctionWithLanguage,
CreateDseFunctionWithNullOption,
CreateDseFunctionWithType {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier functionName;
    private boolean orReplace;
    private boolean ifNotExists;
    private final ImmutableMap<CqlIdentifier, DataType> parameters;
    private boolean returnsNullOnNull;
    private final DataType returnType;
    private final String language;
    private final String functionBody;
    private final boolean deterministic;
    private final boolean globallyMonotonic;
    private final CqlIdentifier monotonicOn;

    public DefaultCreateDseFunction(CqlIdentifier functionName) {
        this(null, functionName);
    }

    public DefaultCreateDseFunction(CqlIdentifier keyspace, CqlIdentifier functionName) {
        this(keyspace, functionName, false, false, (ImmutableMap<CqlIdentifier, DataType>)ImmutableMap.of(), false, null, null, null, false, false, null);
    }

    public DefaultCreateDseFunction(CqlIdentifier keyspace, CqlIdentifier functionName, boolean orReplace, boolean ifNotExists, ImmutableMap<CqlIdentifier, DataType> parameters, boolean returnsNullOnNull, DataType returns, String language, String functionBody, boolean deterministic, boolean globallyMonotonic, CqlIdentifier monotonicOn) {
        this.keyspace = keyspace;
        this.functionName = functionName;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
        this.parameters = parameters;
        this.returnsNullOnNull = returnsNullOnNull;
        this.returnType = returns;
        this.language = language;
        this.functionBody = functionBody;
        this.deterministic = deterministic;
        this.globallyMonotonic = globallyMonotonic;
        this.monotonicOn = monotonicOn;
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (this.orReplace) {
            builder.append("OR REPLACE ");
        }
        builder.append("FUNCTION ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.functionName, builder);
        builder.append(" (");
        boolean first = true;
        for (Map.Entry param : this.parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(((CqlIdentifier)param.getKey()).asCql(true)).append(' ').append(((DataType)param.getValue()).asCql(false, true));
        }
        builder.append(')');
        if (this.returnsNullOnNull) {
            builder.append(" RETURNS NULL");
        } else {
            builder.append(" CALLED");
        }
        builder.append(" ON NULL INPUT");
        if (this.returnType == null) {
            return builder.toString();
        }
        builder.append(" RETURNS ");
        builder.append(this.returnType.asCql(false, true));
        if (this.deterministic) {
            builder.append(" DETERMINISTIC");
        }
        if (this.globallyMonotonic) {
            builder.append(" MONOTONIC");
        } else if (this.monotonicOn != null) {
            builder.append(" MONOTONIC ON ").append(this.monotonicOn.asCql(true));
        }
        if (this.language == null) {
            return builder.toString();
        }
        builder.append(" LANGUAGE ");
        builder.append(this.language);
        if (this.functionBody == null) {
            return builder.toString();
        }
        builder.append(" AS ");
        builder.append(this.functionBody);
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public CreateDseFunctionEnd as(@NonNull String functionBody) {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithLanguage withLanguage(@NonNull String language) {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionStart ifNotExists() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, true, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionStart orReplace() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, true, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionStart withParameter(@NonNull CqlIdentifier paramName, @NonNull DataType paramType) {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, ImmutableCollections.append(this.parameters, paramName, paramType), this.returnsNullOnNull, this.returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithNullOption returnsNullOnNull() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, true, this.returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithNullOption calledOnNull() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, false, this.returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithType deterministic() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody, true, this.globallyMonotonic, this.monotonicOn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithType monotonic() {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody, this.deterministic, true, null);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithType monotonicOn(@NonNull CqlIdentifier monotonicColumn) {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody, this.deterministic, false, monotonicColumn);
    }

    @Override
    @NonNull
    public CreateDseFunctionWithType returnsType(@NonNull DataType returnType) {
        return new DefaultCreateDseFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, returnType, this.language, this.functionBody, this.deterministic, this.globallyMonotonic, this.monotonicOn);
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getFunction() {
        return this.functionName;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getParameters() {
        return this.parameters;
    }

    public boolean isReturnsNullOnNull() {
        return this.returnsNullOnNull;
    }

    @Nullable
    public DataType getReturnType() {
        return this.returnType;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getFunctionBody() {
        return this.functionBody;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean isGloballyMonotonic() {
        return this.globallyMonotonic;
    }

    @Nullable
    public CqlIdentifier getMonotonicOn() {
        return this.monotonicOn;
    }
}

