/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Like;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class EndsWith<T>
extends AbstractCondition
implements QOM.EndsWith<T> {
    final Field<T> string;
    final Field<T> suffix;

    EndsWith(Field<T> string, Field<T> suffix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, suffix.getDataType()));
        this.suffix = Tools.nullableIf(false, Tools.nullSafe(suffix, string.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                return false;
            }
            case DERBY: {
                return false;
            }
            case DUCKDB: {
                return true;
            }
            case CLICKHOUSE: {
                return true;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                this.acceptLike(ctx);
                break;
            }
            case DERBY: {
                this.acceptPosition(ctx);
                break;
            }
            case DUCKDB: {
                ctx.visit(DSL.function(Names.N_SUFFIX, SQLDataType.BOOLEAN, this.string, this.suffix));
                break;
            }
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_endsWith, SQLDataType.BOOLEAN, this.string, this.suffix));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ENDS_WITH, SQLDataType.BOOLEAN, this.string, this.suffix));
            }
        }
    }

    private final void acceptLike(Context<?> ctx) {
        ctx.visit(this.string.like(DSL.concat(DSL.inline("%"), Tools.escapeForLike(this.suffix, ctx.configuration())), '!'));
    }

    private final void acceptPosition(Context<?> ctx) {
        ctx.visit(DSL.position(Like.requiresStringCast(this.string), Like.requiresStringCast(this.suffix)).eq(Internal.iadd(Internal.isub(Like.requiresStringCast(this.string).length(), Like.requiresStringCast(this.suffix).length()), DSL.inline(1))));
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.suffix;
    }

    @Override
    public final QOM.EndsWith<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.EndsWith<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.EndsWith<T>> $constructor() {
        return (a1, a2) -> new EndsWith(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.EndsWith) {
            QOM.EndsWith o = (QOM.EndsWith)that;
            return StringUtils.equals(this.$string(), o.$string()) && StringUtils.equals(this.$suffix(), o.$suffix());
        }
        return super.equals(that);
    }
}

